// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package endpoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/cilium/cilium/api/v1/models"
)

// PatchEndpointIDLabelsReader is a Reader for the PatchEndpointIDLabels structure.
type PatchEndpointIDLabelsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PatchEndpointIDLabelsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPatchEndpointIDLabelsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewPatchEndpointIDLabelsNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewPatchEndpointIDLabelsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewPatchEndpointIDLabelsUpdateFailed()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewPatchEndpointIDLabelsOK creates a PatchEndpointIDLabelsOK with default headers values
func NewPatchEndpointIDLabelsOK() *PatchEndpointIDLabelsOK {
	return &PatchEndpointIDLabelsOK{}
}

/*
PatchEndpointIDLabelsOK describes a response with status code 200, with default header values.

Success
*/
type PatchEndpointIDLabelsOK struct {
}

// IsSuccess returns true when this patch endpoint Id labels o k response has a 2xx status code
func (o *PatchEndpointIDLabelsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this patch endpoint Id labels o k response has a 3xx status code
func (o *PatchEndpointIDLabelsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this patch endpoint Id labels o k response has a 4xx status code
func (o *PatchEndpointIDLabelsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this patch endpoint Id labels o k response has a 5xx status code
func (o *PatchEndpointIDLabelsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this patch endpoint Id labels o k response a status code equal to that given
func (o *PatchEndpointIDLabelsOK) IsCode(code int) bool {
	return code == 200
}

func (o *PatchEndpointIDLabelsOK) Error() string {
	return fmt.Sprintf("[PATCH /endpoint/{id}/labels][%d] patchEndpointIdLabelsOK ", 200)
}

func (o *PatchEndpointIDLabelsOK) String() string {
	return fmt.Sprintf("[PATCH /endpoint/{id}/labels][%d] patchEndpointIdLabelsOK ", 200)
}

func (o *PatchEndpointIDLabelsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPatchEndpointIDLabelsNotFound creates a PatchEndpointIDLabelsNotFound with default headers values
func NewPatchEndpointIDLabelsNotFound() *PatchEndpointIDLabelsNotFound {
	return &PatchEndpointIDLabelsNotFound{}
}

/*
PatchEndpointIDLabelsNotFound describes a response with status code 404, with default header values.

Endpoint not found
*/
type PatchEndpointIDLabelsNotFound struct {
}

// IsSuccess returns true when this patch endpoint Id labels not found response has a 2xx status code
func (o *PatchEndpointIDLabelsNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this patch endpoint Id labels not found response has a 3xx status code
func (o *PatchEndpointIDLabelsNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this patch endpoint Id labels not found response has a 4xx status code
func (o *PatchEndpointIDLabelsNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this patch endpoint Id labels not found response has a 5xx status code
func (o *PatchEndpointIDLabelsNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this patch endpoint Id labels not found response a status code equal to that given
func (o *PatchEndpointIDLabelsNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *PatchEndpointIDLabelsNotFound) Error() string {
	return fmt.Sprintf("[PATCH /endpoint/{id}/labels][%d] patchEndpointIdLabelsNotFound ", 404)
}

func (o *PatchEndpointIDLabelsNotFound) String() string {
	return fmt.Sprintf("[PATCH /endpoint/{id}/labels][%d] patchEndpointIdLabelsNotFound ", 404)
}

func (o *PatchEndpointIDLabelsNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPatchEndpointIDLabelsTooManyRequests creates a PatchEndpointIDLabelsTooManyRequests with default headers values
func NewPatchEndpointIDLabelsTooManyRequests() *PatchEndpointIDLabelsTooManyRequests {
	return &PatchEndpointIDLabelsTooManyRequests{}
}

/*
PatchEndpointIDLabelsTooManyRequests describes a response with status code 429, with default header values.

Rate-limiting too many requests in the given time frame
*/
type PatchEndpointIDLabelsTooManyRequests struct {
}

// IsSuccess returns true when this patch endpoint Id labels too many requests response has a 2xx status code
func (o *PatchEndpointIDLabelsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this patch endpoint Id labels too many requests response has a 3xx status code
func (o *PatchEndpointIDLabelsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this patch endpoint Id labels too many requests response has a 4xx status code
func (o *PatchEndpointIDLabelsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this patch endpoint Id labels too many requests response has a 5xx status code
func (o *PatchEndpointIDLabelsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this patch endpoint Id labels too many requests response a status code equal to that given
func (o *PatchEndpointIDLabelsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

func (o *PatchEndpointIDLabelsTooManyRequests) Error() string {
	return fmt.Sprintf("[PATCH /endpoint/{id}/labels][%d] patchEndpointIdLabelsTooManyRequests ", 429)
}

func (o *PatchEndpointIDLabelsTooManyRequests) String() string {
	return fmt.Sprintf("[PATCH /endpoint/{id}/labels][%d] patchEndpointIdLabelsTooManyRequests ", 429)
}

func (o *PatchEndpointIDLabelsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPatchEndpointIDLabelsUpdateFailed creates a PatchEndpointIDLabelsUpdateFailed with default headers values
func NewPatchEndpointIDLabelsUpdateFailed() *PatchEndpointIDLabelsUpdateFailed {
	return &PatchEndpointIDLabelsUpdateFailed{}
}

/*
PatchEndpointIDLabelsUpdateFailed describes a response with status code 500, with default header values.

Error while updating labels
*/
type PatchEndpointIDLabelsUpdateFailed struct {
	Payload models.Error
}

// IsSuccess returns true when this patch endpoint Id labels update failed response has a 2xx status code
func (o *PatchEndpointIDLabelsUpdateFailed) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this patch endpoint Id labels update failed response has a 3xx status code
func (o *PatchEndpointIDLabelsUpdateFailed) IsRedirect() bool {
	return false
}

// IsClientError returns true when this patch endpoint Id labels update failed response has a 4xx status code
func (o *PatchEndpointIDLabelsUpdateFailed) IsClientError() bool {
	return false
}

// IsServerError returns true when this patch endpoint Id labels update failed response has a 5xx status code
func (o *PatchEndpointIDLabelsUpdateFailed) IsServerError() bool {
	return true
}

// IsCode returns true when this patch endpoint Id labels update failed response a status code equal to that given
func (o *PatchEndpointIDLabelsUpdateFailed) IsCode(code int) bool {
	return code == 500
}

func (o *PatchEndpointIDLabelsUpdateFailed) Error() string {
	return fmt.Sprintf("[PATCH /endpoint/{id}/labels][%d] patchEndpointIdLabelsUpdateFailed  %+v", 500, o.Payload)
}

func (o *PatchEndpointIDLabelsUpdateFailed) String() string {
	return fmt.Sprintf("[PATCH /endpoint/{id}/labels][%d] patchEndpointIdLabelsUpdateFailed  %+v", 500, o.Payload)
}

func (o *PatchEndpointIDLabelsUpdateFailed) GetPayload() models.Error {
	return o.Payload
}

func (o *PatchEndpointIDLabelsUpdateFailed) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
