// SPDX-License-Identifier: Apache-2.0
// Copyright Authors of Cilium

// Code generated by client-gen. DO NOT EDIT.

package v2alpha1

import (
	"context"
	"time"

	v2alpha1 "github.com/cilium/cilium/pkg/k8s/apis/cilium.io/v2alpha1"
	scheme "github.com/cilium/cilium/pkg/k8s/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// CiliumEndpointSlicesGetter has a method to return a CiliumEndpointSliceInterface.
// A group's client should implement this interface.
type CiliumEndpointSlicesGetter interface {
	CiliumEndpointSlices() CiliumEndpointSliceInterface
}

// CiliumEndpointSliceInterface has methods to work with CiliumEndpointSlice resources.
type CiliumEndpointSliceInterface interface {
	Create(ctx context.Context, ciliumEndpointSlice *v2alpha1.CiliumEndpointSlice, opts v1.CreateOptions) (*v2alpha1.CiliumEndpointSlice, error)
	Update(ctx context.Context, ciliumEndpointSlice *v2alpha1.CiliumEndpointSlice, opts v1.UpdateOptions) (*v2alpha1.CiliumEndpointSlice, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v2alpha1.CiliumEndpointSlice, error)
	List(ctx context.Context, opts v1.ListOptions) (*v2alpha1.CiliumEndpointSliceList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2alpha1.CiliumEndpointSlice, err error)
	CiliumEndpointSliceExpansion
}

// ciliumEndpointSlices implements CiliumEndpointSliceInterface
type ciliumEndpointSlices struct {
	client rest.Interface
}

// newCiliumEndpointSlices returns a CiliumEndpointSlices
func newCiliumEndpointSlices(c *CiliumV2alpha1Client) *ciliumEndpointSlices {
	return &ciliumEndpointSlices{
		client: c.RESTClient(),
	}
}

// Get takes name of the ciliumEndpointSlice, and returns the corresponding ciliumEndpointSlice object, and an error if there is any.
func (c *ciliumEndpointSlices) Get(ctx context.Context, name string, options v1.GetOptions) (result *v2alpha1.CiliumEndpointSlice, err error) {
	result = &v2alpha1.CiliumEndpointSlice{}
	err = c.client.Get().
		Resource("ciliumendpointslices").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of CiliumEndpointSlices that match those selectors.
func (c *ciliumEndpointSlices) List(ctx context.Context, opts v1.ListOptions) (result *v2alpha1.CiliumEndpointSliceList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v2alpha1.CiliumEndpointSliceList{}
	err = c.client.Get().
		Resource("ciliumendpointslices").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested ciliumEndpointSlices.
func (c *ciliumEndpointSlices) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("ciliumendpointslices").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a ciliumEndpointSlice and creates it.  Returns the server's representation of the ciliumEndpointSlice, and an error, if there is any.
func (c *ciliumEndpointSlices) Create(ctx context.Context, ciliumEndpointSlice *v2alpha1.CiliumEndpointSlice, opts v1.CreateOptions) (result *v2alpha1.CiliumEndpointSlice, err error) {
	result = &v2alpha1.CiliumEndpointSlice{}
	err = c.client.Post().
		Resource("ciliumendpointslices").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ciliumEndpointSlice).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a ciliumEndpointSlice and updates it. Returns the server's representation of the ciliumEndpointSlice, and an error, if there is any.
func (c *ciliumEndpointSlices) Update(ctx context.Context, ciliumEndpointSlice *v2alpha1.CiliumEndpointSlice, opts v1.UpdateOptions) (result *v2alpha1.CiliumEndpointSlice, err error) {
	result = &v2alpha1.CiliumEndpointSlice{}
	err = c.client.Put().
		Resource("ciliumendpointslices").
		Name(ciliumEndpointSlice.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ciliumEndpointSlice).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the ciliumEndpointSlice and deletes it. Returns an error if one occurs.
func (c *ciliumEndpointSlices) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("ciliumendpointslices").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *ciliumEndpointSlices) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("ciliumendpointslices").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched ciliumEndpointSlice.
func (c *ciliumEndpointSlices) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2alpha1.CiliumEndpointSlice, err error) {
	result = &v2alpha1.CiliumEndpointSlice{}
	err = c.client.Patch(pt).
		Resource("ciliumendpointslices").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
