/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.chunk;

import java.io.IOException;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.IChunkReader;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReader;

public class DiskChunkLoader
implements IChunkLoader {
    private final boolean debug;

    public DiskChunkLoader(boolean debug) {
        this.debug = debug;
    }

    public Chunk loadChunk(ChunkMetadata chunkMetaData) throws IOException {
        return ChunkCache.getInstance().get(chunkMetaData, this.debug);
    }

    public void close() {
    }

    public IChunkReader getChunkReader(IChunkMetadata chunkMetaData, Filter timeFilter) throws IOException {
        Chunk chunk = ChunkCache.getInstance().get((ChunkMetadata)chunkMetaData, this.debug);
        chunk.setFromOldFile(chunkMetaData.isFromOldTsFile());
        return new ChunkReader(chunk, timeFilter);
    }
}

