/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.cross.rewrite.selector;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;

public abstract class AbstractCompactionEstimator
implements AutoCloseable {
    protected Map<TsFileResource, TsFileSequenceReader> fileReaderCache = new HashMap<TsFileResource, TsFileSequenceReader>();

    public abstract long estimateCrossCompactionMemory(List<TsFileResource> var1, TsFileResource var2) throws IOException;

    public abstract long estimateInnerCompactionMemory(List<TsFileResource> var1);

    protected TsFileSequenceReader getFileReader(TsFileResource tsFileResource) throws IOException {
        TsFileSequenceReader reader = this.fileReaderCache.get(tsFileResource);
        if (reader == null) {
            reader = new TsFileSequenceReader(tsFileResource.getTsFilePath(), true, false);
            this.fileReaderCache.put(tsFileResource, reader);
        }
        return reader;
    }

    @Override
    public void close() throws Exception {
        for (TsFileSequenceReader sequenceReader : this.fileReaderCache.values()) {
            sequenceReader.close();
        }
        this.fileReaderCache.clear();
    }
}

