/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.CompactionTaskManager;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.task.SubCompactionTask;
import org.apache.iotdb.db.engine.compaction.inner.utils.MultiTsFileDeviceIterator;
import org.apache.iotdb.db.engine.compaction.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.engine.compaction.writer.CrossSpaceCompactionWriter;
import org.apache.iotdb.db.engine.compaction.writer.InnerSpaceCompactionWriter;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.reader.series.SeriesRawDataBatchReader;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.QueryUtils;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.reader.IBatchReader;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)"COMPACTION");
    private static final int subTaskNum = IoTDBDescriptor.getInstance().getConfig().getSubCompactionTaskNum();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compact(List<TsFileResource> seqFileResources, List<TsFileResource> unseqFileResources, List<TsFileResource> targetFileResources) throws IOException, MetadataException, StorageEngineException, InterruptedException {
        long queryId = QueryResourceManager.getInstance().assignCompactionQueryId();
        QueryContext queryContext = new QueryContext(queryId);
        QueryDataSource queryDataSource = new QueryDataSource(seqFileResources, unseqFileResources);
        QueryResourceManager.getInstance().getQueryFileManager().addUsedFilesForQuery(queryId, queryDataSource);
        try (AbstractCompactionWriter compactionWriter = CompactionUtils.getCompactionWriter(seqFileResources, unseqFileResources, targetFileResources);){
            MultiTsFileDeviceIterator deviceIterator = new MultiTsFileDeviceIterator(seqFileResources, unseqFileResources);
            while (deviceIterator.hasNextDevice()) {
                CompactionUtils.checkThreadInterrupted(targetFileResources);
                Pair<String, Boolean> deviceInfo = deviceIterator.nextDevice();
                String device = (String)deviceInfo.left;
                boolean isAligned = (Boolean)deviceInfo.right;
                QueryUtils.fillOrderIndexes(queryDataSource, device, true);
                if (isAligned) {
                    CompactionUtils.compactAlignedSeries(device, deviceIterator, compactionWriter, queryContext, queryDataSource);
                    continue;
                }
                CompactionUtils.compactNonAlignedSeries(device, deviceIterator, compactionWriter, queryContext, queryDataSource);
            }
            compactionWriter.endFile();
            CompactionUtils.updatePlanIndexes(targetFileResources, seqFileResources, unseqFileResources);
        }
        finally {
            QueryResourceManager.getInstance().endQuery(queryId);
        }
    }

    private static void compactAlignedSeries(String device, MultiTsFileDeviceIterator deviceIterator, AbstractCompactionWriter compactionWriter, QueryContext queryContext, QueryDataSource queryDataSource) throws IOException, MetadataException {
        Map<String, MeasurementSchema> schemaMap = deviceIterator.getAllSchemasOfCurrentDevice();
        ArrayList<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>(schemaMap.values());
        if (measurementSchemas.isEmpty()) {
            return;
        }
        List<String> existedMeasurements = measurementSchemas.stream().map(IMeasurementSchema::getMeasurementId).collect(Collectors.toList());
        IBatchReader dataBatchReader = CompactionUtils.constructReader(device, existedMeasurements, measurementSchemas, schemaMap.keySet(), queryContext, queryDataSource, true);
        if (dataBatchReader.hasNextBatch()) {
            compactionWriter.startChunkGroup(device, true);
            compactionWriter.startMeasurement(measurementSchemas, 0);
            CompactionUtils.writeWithReader(compactionWriter, dataBatchReader, 0);
            compactionWriter.endMeasurement(0);
            compactionWriter.endChunkGroup();
        }
        compactionWriter.checkAndMayFlushChunkMetadata();
    }

    private static void compactNonAlignedSeries(String device, MultiTsFileDeviceIterator deviceIterator, AbstractCompactionWriter compactionWriter, QueryContext queryContext, QueryDataSource queryDataSource) throws IOException, InterruptedException {
        Map<String, MeasurementSchema> schemaMap = deviceIterator.getAllSchemasOfCurrentDevice();
        ArrayList<String> allMeasurements = new ArrayList<String>(schemaMap.keySet());
        allMeasurements.sort(String::compareTo);
        int subTaskNums = Math.min(allMeasurements.size(), subTaskNum);
        if (subTaskNums > 0) {
            int i;
            List[] measurementListArray = new List[subTaskNums];
            int size = allMeasurements.size();
            for (int i2 = 0; i2 < size; ++i2) {
                int index = i2 % subTaskNums;
                if (measurementListArray[index] == null) {
                    measurementListArray[index] = new LinkedList();
                }
                measurementListArray[index].add((String)allMeasurements.get(i2));
            }
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
            compactionWriter.startChunkGroup(device, false);
            for (i = 0; i < subTaskNums; ++i) {
                futures.add(CompactionTaskManager.getInstance().submitSubTask(new SubCompactionTask(device, measurementListArray[i], queryContext, queryDataSource, compactionWriter, schemaMap, i)));
            }
            for (i = 0; i < subTaskNums; ++i) {
                try {
                    ((Future)futures.get(i)).get();
                    continue;
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.error("SubCompactionTask meet errors ", (Throwable)e);
                    Thread.interrupted();
                    throw new InterruptedException();
                }
            }
        }
        compactionWriter.endChunkGroup();
        compactionWriter.checkAndMayFlushChunkMetadata();
    }

    public static void writeWithReader(AbstractCompactionWriter writer, IBatchReader reader, int subTaskId) throws IOException {
        while (reader.hasNextBatch()) {
            BatchData batchData = reader.nextBatch();
            while (batchData.hasCurrent()) {
                writer.write(batchData.currentTime(), batchData.currentValue(), subTaskId);
                batchData.next();
            }
        }
    }

    public static IBatchReader constructReader(String deviceId, List<String> measurementIds, List<IMeasurementSchema> measurementSchemas, Set<String> allSensors, QueryContext queryContext, QueryDataSource queryDataSource, boolean isAlign) throws IllegalPathException {
        TSDataType tsDataType;
        PartialPath seriesPath;
        if (isAlign) {
            seriesPath = new AlignedPath(deviceId, measurementIds, measurementSchemas);
            tsDataType = TSDataType.VECTOR;
        } else {
            seriesPath = new MeasurementPath(deviceId, measurementIds.get(0), measurementSchemas.get(0));
            tsDataType = measurementSchemas.get(0).getType();
        }
        return new SeriesRawDataBatchReader(seriesPath, allSensors, tsDataType, queryContext, queryDataSource, null, null, null, true);
    }

    private static AbstractCompactionWriter getCompactionWriter(List<TsFileResource> seqFileResources, List<TsFileResource> unseqFileResources, List<TsFileResource> targetFileResources) throws IOException {
        if (!seqFileResources.isEmpty() && !unseqFileResources.isEmpty()) {
            return new CrossSpaceCompactionWriter(targetFileResources, seqFileResources);
        }
        return new InnerSpaceCompactionWriter(targetFileResources.get(0));
    }

    private static void updatePlanIndexes(List<TsFileResource> targetResources, List<TsFileResource> seqResources, List<TsFileResource> unseqResources) {
        for (int i = 0; i < targetResources.size(); ++i) {
            TsFileResource targetResource = targetResources.get(i);
            for (TsFileResource unseqResource : unseqResources) {
                targetResource.updatePlanIndexes(unseqResource);
            }
            for (TsFileResource seqResource : seqResources) {
                targetResource.updatePlanIndexes(seqResource);
            }
        }
    }

    public static void moveTargetFile(List<TsFileResource> targetResources, boolean isInnerSpace, String fullStorageGroupName) throws IOException, WriteProcessException {
        String fileSuffix = isInnerSpace ? ".inner" : ".cross";
        for (TsFileResource targetResource : targetResources) {
            CompactionUtils.moveOneTargetFile(targetResource, fileSuffix, fullStorageGroupName);
        }
    }

    private static void moveOneTargetFile(TsFileResource targetResource, String tmpFileSuffix, String fullStorageGroupName) throws IOException {
        if (!targetResource.getTsFile().exists()) {
            logger.info("{} [Compaction] Tmp target tsfile {} may be deleted after compaction.", (Object)fullStorageGroupName, (Object)targetResource.getTsFilePath());
            return;
        }
        File newFile = new File(targetResource.getTsFilePath().replace(tmpFileSuffix, ".tsfile"));
        if (!newFile.exists()) {
            FSFactoryProducer.getFSFactory().moveFile(targetResource.getTsFile(), newFile);
        }
        targetResource.setFile(newFile);
        targetResource.serialize();
        targetResource.closeWithoutSettingStatus();
    }

    public static void combineModsInCompaction(List<TsFileResource> seqResources, List<TsFileResource> unseqResources, List<TsFileResource> targetResources) throws IOException {
        HashSet<Modification> modifications = new HashSet<Modification>();
        for (TsFileResource unseqFile : unseqResources) {
            modifications.addAll(ModificationFile.getCompactionMods(unseqFile).getModifications());
        }
        for (int i = 0; i < targetResources.size(); ++i) {
            TsFileResource targetResource = targetResources.get(i);
            if (targetResource == null) continue;
            HashSet<Modification> seqModifications = new HashSet<Modification>(ModificationFile.getCompactionMods(seqResources.get(i)).getModifications());
            modifications.addAll(seqModifications);
            CompactionUtils.updateOneTargetMods(targetResource, modifications);
            modifications.removeAll(seqModifications);
        }
    }

    private static void updateOneTargetMods(TsFileResource targetFile, Set<Modification> modifications) throws IOException {
        if (!modifications.isEmpty()) {
            try (ModificationFile modificationFile = ModificationFile.getNormalMods(targetFile);){
                for (Modification modification : modifications) {
                    modification.setFileOffset(Long.MAX_VALUE);
                    modificationFile.write(modification);
                }
            }
        }
    }

    public static void deleteCompactionModsFile(List<TsFileResource> selectedSeqTsFileResourceList, List<TsFileResource> selectedUnSeqTsFileResourceList) throws IOException {
        ModificationFile modificationFile;
        for (TsFileResource seqFile : selectedSeqTsFileResourceList) {
            modificationFile = seqFile.getCompactionModFile();
            if (!modificationFile.exists()) continue;
            modificationFile.remove();
        }
        for (TsFileResource unseqFile : selectedUnSeqTsFileResourceList) {
            modificationFile = unseqFile.getCompactionModFile();
            if (!modificationFile.exists()) continue;
            modificationFile.remove();
        }
    }

    private static void checkThreadInterrupted(List<TsFileResource> tsFileResource) throws InterruptedException {
        if (Thread.interrupted() || !IoTDB.activated) {
            throw new InterruptedException(String.format("[Compaction] compaction for target file %s abort", tsFileResource.toString()));
        }
    }
}

