/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.micrometer.type;

import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;

public class MicrometerHistogramSnapshot
implements org.apache.iotdb.metrics.type.HistogramSnapshot {
    HistogramSnapshot histogramSnapshot;

    public MicrometerHistogramSnapshot(HistogramSnapshot histogramSnapshot) {
        this.histogramSnapshot = histogramSnapshot;
    }

    public double getValue(double quantile) {
        int prevIndex = 0;
        for (int i = 0; i < this.histogramSnapshot.percentileValues().length; ++i) {
            if (this.histogramSnapshot.percentileValues()[i].percentile() <= quantile) {
                prevIndex = i;
            }
            if (this.histogramSnapshot.percentileValues()[i].percentile() >= quantile) break;
        }
        return this.histogramSnapshot.percentileValues()[prevIndex].value();
    }

    public long[] getValues() {
        return Arrays.stream(this.histogramSnapshot.percentileValues()).mapToLong(k -> (long)k.value()).toArray();
    }

    public int size() {
        return this.histogramSnapshot.percentileValues().length;
    }

    public double getMedian() {
        return this.getValue(0.5);
    }

    public long getMax() {
        return (long)this.histogramSnapshot.max();
    }

    public double getMean() {
        return this.histogramSnapshot.mean();
    }

    public long getMin() {
        return (long)this.getValue(0.0);
    }

    public void dump(OutputStream output) {
        this.histogramSnapshot.outputSummary((PrintStream)output, 100.0);
    }
}

