/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.iotdb.tsfile.file.header.ChunkGroupHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexEntry;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexNode;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.MetadataIndexNodeType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.BloomFilter;
import org.apache.iotdb.tsfile.utils.Pair;

public class TsFileSketchTool {
    private String filename;
    private PrintWriter pw;
    private TsFileSketchToolReader reader;
    private String splitStr;
    TsFileMetadata tsFileMetaData;
    List<ChunkGroupMetadata> allChunkGroupMetadata;

    public static void main(String[] args) throws IOException {
        Pair<String, String> fileNames = TsFileSketchTool.checkArgs(args);
        String filename = (String)fileNames.left;
        String outFile = (String)fileNames.right;
        System.out.println("TsFile path:" + filename);
        System.out.println("Sketch save path:" + outFile);
        new TsFileSketchTool(filename, outFile).run();
    }

    public TsFileSketchTool(String filename, String outFile) {
        try {
            this.filename = filename;
            this.pw = new PrintWriter(new FileWriter(outFile));
            this.reader = new TsFileSketchToolReader(filename);
            StringBuilder str1 = new StringBuilder();
            for (int i = 0; i < 21; ++i) {
                str1.append("|");
            }
            this.splitStr = str1.toString();
            this.tsFileMetaData = this.reader.readFileMetadata();
            this.allChunkGroupMetadata = new ArrayList<ChunkGroupMetadata>();
            if (this.reader.selfCheck(null, this.allChunkGroupMetadata, false) != 0L) {
                throw new IOException(String.format("Cannot load file %s because the file has crashed.", filename));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void run() throws IOException {
        long length = FSFactoryProducer.getFSFactory().getFile(this.filename).length();
        this.printlnBoth(this.pw, "-------------------------------- TsFile Sketch --------------------------------");
        this.printlnBoth(this.pw, "file path: " + this.filename);
        this.printlnBoth(this.pw, "file length: " + length);
        this.printFileInfo();
        this.printChunk(this.allChunkGroupMetadata);
        if (this.tsFileMetaData.getMetadataIndex().getChildren().isEmpty()) {
            this.printlnBoth(this.pw, String.format("%20s", this.reader.getFileMetadataPos() - 1L) + "|\t[marker] 2");
        } else {
            this.printlnBoth(this.pw, String.format("%20s", this.reader.readFileMetadata().getMetaOffset()) + "|\t[marker] 2");
        }
        Map<Long, Pair<Path, TimeseriesMetadata>> timeseriesMetadataMap = this.reader.getAllTimeseriesMetadataWithOffset();
        this.printTimeseriesIndex(timeseriesMetadataMap);
        MetadataIndexNode metadataIndexNode = this.tsFileMetaData.getMetadataIndex();
        TreeMap<Long, MetadataIndexNode> metadataIndexNodeMap = new TreeMap<Long, MetadataIndexNode>();
        ArrayList<String> treeOutputStringBuffer = new ArrayList<String>();
        this.loadIndexTree(metadataIndexNode, metadataIndexNodeMap, treeOutputStringBuffer, 0);
        this.printIndexOfTimerseriesIndex(metadataIndexNodeMap);
        this.printTsFileMetadata(this.tsFileMetaData);
        this.printlnBoth(this.pw, String.format("%20s", length) + "|\tEND of TsFile");
        this.printlnBoth(this.pw, "---------------------------- IndexOfTimerseriesIndex Tree -----------------------------");
        for (String str : treeOutputStringBuffer) {
            this.printlnBoth(this.pw, str);
        }
        this.printlnBoth(this.pw, "---------------------------------- TsFile Sketch End ----------------------------------");
        this.reader.close();
        this.pw.close();
    }

    private void printTsFileMetadata(TsFileMetadata tsFileMetaData) {
        try {
            this.printlnBoth(this.pw, String.format("%20s", this.reader.getFileMetadataPos()) + "|\t[TsFileMetadata]");
            this.printlnBoth(this.pw, String.format("%20s", "") + "|\t\t[meta offset] " + tsFileMetaData.getMetaOffset());
            this.printlnBoth(this.pw, String.format("%20s", "") + "|\t\t[num of devices] " + tsFileMetaData.getMetadataIndex().getChildren().size());
            this.printlnBoth(this.pw, String.format("%20s", "") + "|\t\t" + tsFileMetaData.getMetadataIndex().getChildren().size() + " key&TsMetadataIndex");
            BloomFilter bloomFilter = tsFileMetaData.getBloomFilter();
            this.printlnBoth(this.pw, String.format("%20s", "") + "|\t\t[bloom filter bit vector byte array length] " + bloomFilter.serialize().length);
            this.printlnBoth(this.pw, String.format("%20s", "") + "|\t\t[bloom filter bit vector byte array] ");
            this.printlnBoth(this.pw, String.format("%20s", "") + "|\t\t[bloom filter number of bits] " + bloomFilter.getSize());
            this.printlnBoth(this.pw, String.format("%20s", "") + "|\t\t[bloom filter number of hash functions] " + bloomFilter.getHashFunctionSize());
            this.printlnBoth(this.pw, String.format("%20s", this.reader.getFileMetadataPos() + (long)this.reader.getFileMetadataSize()) + "|\t[TsFileMetadataSize] " + this.reader.getFileMetadataSize());
            this.printlnBoth(this.pw, String.format("%20s", this.reader.getFileMetadataPos() + (long)this.reader.getFileMetadataSize() + 4L) + "|\t[magic tail] " + this.reader.readTailMagic());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void printIndexOfTimerseriesIndex(TreeMap<Long, MetadataIndexNode> metadataIndexNodeMap) {
        for (Map.Entry<Long, MetadataIndexNode> entry : metadataIndexNodeMap.entrySet()) {
            this.printlnBoth(this.pw, String.format("%20s", entry.getKey()) + "|\t[IndexOfTimerseriesIndex Node] type=" + entry.getValue().getNodeType());
            for (MetadataIndexEntry metadataIndexEntry : entry.getValue().getChildren()) {
                this.printlnBoth(this.pw, String.format("%20s", "") + "|\t\t<" + metadataIndexEntry.getName() + ", " + metadataIndexEntry.getOffset() + ">");
            }
            this.printlnBoth(this.pw, String.format("%20s", "") + "|\t\t<endOffset, " + entry.getValue().getEndOffset() + ">");
        }
    }

    private void printFileInfo() {
        try {
            this.printlnBoth(this.pw, "");
            this.printlnBoth(this.pw, String.format("%20s", "POSITION") + "|\tCONTENT");
            this.printlnBoth(this.pw, String.format("%20s", "--------") + " \t-------");
            this.printlnBoth(this.pw, String.format("%20d", 0) + "|\t[magic head] " + this.reader.readHeadMagic());
            this.printlnBoth(this.pw, String.format("%20d", "TsFile".getBytes().length) + "|\t[version number] " + this.reader.readVersionNumber());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void printChunk(List<ChunkGroupMetadata> allChunkGroupMetadata) {
        try {
            long nextChunkGroupHeaderPos = (long)"TsFile".getBytes().length + 1L;
            for (ChunkGroupMetadata chunkGroupMetadata : allChunkGroupMetadata) {
                this.printlnBoth(this.pw, this.splitStr + "\t[Chunk Group] of " + chunkGroupMetadata.getDevice() + ", num of Chunks:" + chunkGroupMetadata.getChunkMetadataList().size());
                this.printlnBoth(this.pw, String.format("%20s", nextChunkGroupHeaderPos) + "|\t[Chunk Group Header]");
                ChunkGroupHeader chunkGroupHeader = this.reader.readChunkGroupHeader(nextChunkGroupHeaderPos, false);
                this.printlnBoth(this.pw, String.format("%20s", "") + "|\t\t[marker] 0");
                this.printlnBoth(this.pw, String.format("%20s", "") + "|\t\t[deviceID] " + chunkGroupHeader.getDeviceID());
                for (ChunkMetadata chunkMetadata : chunkGroupMetadata.getChunkMetadataList()) {
                    Chunk chunk = this.reader.readMemChunk(chunkMetadata);
                    this.printlnBoth(this.pw, String.format("%20d", chunkMetadata.getOffsetOfChunkHeader()) + "|\t[Chunk] of " + chunkMetadata.getMeasurementUid() + ", numOfPoints:" + chunkMetadata.getNumOfPoints() + ", time range:[" + chunkMetadata.getStartTime() + "," + chunkMetadata.getEndTime() + "], tsDataType:" + chunkMetadata.getDataType() + ", \n" + String.format("%20s", "") + " \t" + chunkMetadata.getStatistics());
                    this.printlnBoth(this.pw, String.format("%20s", "") + "|\t\t[chunk header] marker=" + chunk.getHeader().getChunkType() + ", measurementId=" + chunk.getHeader().getMeasurementID() + ", dataSize=" + chunk.getHeader().getDataSize() + ", serializedSize=" + chunk.getHeader().getSerializedSize());
                    this.printlnBoth(this.pw, String.format("%20s", "") + "|\t\t[chunk] " + chunk.getData());
                    PageHeader pageHeader = (byte)(chunk.getHeader().getChunkType() & 0x3F) == 5 ? PageHeader.deserializeFrom((ByteBuffer)chunk.getData(), (Statistics)chunkMetadata.getStatistics()) : PageHeader.deserializeFrom((ByteBuffer)chunk.getData(), (TSDataType)chunk.getHeader().getDataType());
                    this.printlnBoth(this.pw, String.format("%20s", "") + "|\t\t[page]  CompressedSize:" + pageHeader.getCompressedSize() + ", UncompressedSize:" + pageHeader.getUncompressedSize());
                    nextChunkGroupHeaderPos = chunkMetadata.getOffsetOfChunkHeader() + (long)chunk.getHeader().getSerializedSize() + (long)chunk.getHeader().getDataSize();
                }
                this.reader.position(nextChunkGroupHeaderPos);
                byte marker = this.reader.readMarker();
                switch (marker) {
                    case 0: {
                        break;
                    }
                    case 4: {
                        nextChunkGroupHeaderPos += 16L;
                    }
                }
                this.printlnBoth(this.pw, this.splitStr + "\t[Chunk Group] of " + chunkGroupMetadata.getDevice() + " ends");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void printTimeseriesIndex(Map<Long, Pair<Path, TimeseriesMetadata>> timeseriesMetadataMap) {
        try {
            for (Map.Entry<Long, Pair<Path, TimeseriesMetadata>> entry : timeseriesMetadataMap.entrySet()) {
                this.printlnBoth(this.pw, String.format("%20s", entry.getKey()) + "|\t[TimeseriesIndex] of " + entry.getValue().left + ", tsDataType:" + ((TimeseriesMetadata)entry.getValue().right).getTSDataType());
                for (IChunkMetadata chunkMetadata : this.reader.getChunkMetadataList((Path)entry.getValue().left)) {
                    this.printlnBoth(this.pw, String.format("%20s", "") + "|\t\t[ChunkIndex] " + chunkMetadata.getMeasurementUid() + ", offset=" + chunkMetadata.getOffsetOfChunkHeader());
                }
                this.printlnBoth(this.pw, String.format("%20s", "") + "|\t\t[" + ((TimeseriesMetadata)entry.getValue().right).getStatistics() + "] ");
            }
            this.printlnBoth(this.pw, this.splitStr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadIndexTree(MetadataIndexNode metadataIndexNode, TreeMap<Long, MetadataIndexNode> metadataIndexNodeMap, List<String> treeOutputStringBuffer, int deep) throws IOException {
        int i;
        StringBuilder tableWriter = new StringBuilder("\t");
        for (i = 0; i < deep; ++i) {
            tableWriter.append("\t\t");
        }
        treeOutputStringBuffer.add(tableWriter.toString() + "[MetadataIndex:" + metadataIndexNode.getNodeType() + "]");
        for (i = 0; i < metadataIndexNode.getChildren().size(); ++i) {
            MetadataIndexEntry metadataIndexEntry = (MetadataIndexEntry)metadataIndexNode.getChildren().get(i);
            treeOutputStringBuffer.add(tableWriter.toString() + "\u2514\u2500\u2500\u2500\u2500\u2500\u2500[" + metadataIndexEntry.getName() + "," + metadataIndexEntry.getOffset() + "]");
            if (metadataIndexNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) continue;
            long endOffset = metadataIndexNode.getEndOffset();
            if (i != metadataIndexNode.getChildren().size() - 1) {
                endOffset = ((MetadataIndexEntry)metadataIndexNode.getChildren().get(i + 1)).getOffset();
            }
            MetadataIndexNode subNode = this.reader.getMetadataIndexNode(metadataIndexEntry.getOffset(), endOffset);
            metadataIndexNodeMap.put(metadataIndexEntry.getOffset(), subNode);
            this.loadIndexTree(subNode, metadataIndexNodeMap, treeOutputStringBuffer, deep + 1);
        }
    }

    private void printlnBoth(PrintWriter pw, String str) {
        System.out.println(str);
        pw.println(str);
    }

    private static Pair<String, String> checkArgs(String[] args) {
        String filename = "test.tsfile";
        String outFile = "TsFile_sketch_view.txt";
        if (args.length == 1) {
            filename = args[0];
        } else if (args.length == 2) {
            filename = args[0];
            outFile = args[1];
        }
        return new Pair((Object)filename, (Object)outFile);
    }

    protected List<ChunkGroupMetadata> getAllChunkGroupMetadata() {
        return this.allChunkGroupMetadata;
    }

    private class TsFileSketchToolReader
    extends TsFileSequenceReader {
        public TsFileSketchToolReader(String file) throws IOException {
            super(file);
        }

        private void generateMetadataIndexWithOffset(long startOffset, MetadataIndexEntry metadataIndex, ByteBuffer buffer, String deviceId, MetadataIndexNodeType type, Map<Long, Pair<Path, TimeseriesMetadata>> timeseriesMetadataMap, boolean needChunkMetadata) throws IOException {
            if (type.equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
                while (buffer.hasRemaining()) {
                    long pos = startOffset + (long)buffer.position();
                    TimeseriesMetadata timeseriesMetadata = TimeseriesMetadata.deserializeFrom((ByteBuffer)buffer, (boolean)needChunkMetadata);
                    timeseriesMetadataMap.put(pos, (Pair<Path, TimeseriesMetadata>)new Pair((Object)new Path(deviceId, timeseriesMetadata.getMeasurementId()), (Object)timeseriesMetadata));
                }
            } else {
                if (type.equals((Object)MetadataIndexNodeType.LEAF_DEVICE)) {
                    deviceId = metadataIndex.getName();
                }
                MetadataIndexNode metadataIndexNode = MetadataIndexNode.deserializeFrom((ByteBuffer)buffer);
                int metadataIndexListSize = metadataIndexNode.getChildren().size();
                for (int i = 0; i < metadataIndexListSize; ++i) {
                    long endOffset = metadataIndexNode.getEndOffset();
                    if (i != metadataIndexListSize - 1) {
                        endOffset = ((MetadataIndexEntry)metadataIndexNode.getChildren().get(i + 1)).getOffset();
                    }
                    ByteBuffer nextBuffer = this.readData(((MetadataIndexEntry)metadataIndexNode.getChildren().get(i)).getOffset(), endOffset);
                    this.generateMetadataIndexWithOffset(((MetadataIndexEntry)metadataIndexNode.getChildren().get(i)).getOffset(), (MetadataIndexEntry)metadataIndexNode.getChildren().get(i), nextBuffer, deviceId, metadataIndexNode.getNodeType(), timeseriesMetadataMap, needChunkMetadata);
                }
            }
        }

        public Map<Long, Pair<Path, TimeseriesMetadata>> getAllTimeseriesMetadataWithOffset() throws IOException {
            if (this.tsFileMetaData == null) {
                this.readFileMetadata();
            }
            MetadataIndexNode metadataIndexNode = this.tsFileMetaData.getMetadataIndex();
            TreeMap<Long, Pair<Path, TimeseriesMetadata>> timeseriesMetadataMap = new TreeMap<Long, Pair<Path, TimeseriesMetadata>>();
            List metadataIndexEntryList = metadataIndexNode.getChildren();
            for (int i = 0; i < metadataIndexEntryList.size(); ++i) {
                MetadataIndexEntry metadataIndexEntry = (MetadataIndexEntry)metadataIndexEntryList.get(i);
                long endOffset = this.tsFileMetaData.getMetadataIndex().getEndOffset();
                if (i != metadataIndexEntryList.size() - 1) {
                    endOffset = ((MetadataIndexEntry)metadataIndexEntryList.get(i + 1)).getOffset();
                }
                ByteBuffer buffer = this.readData(metadataIndexEntry.getOffset(), endOffset);
                this.generateMetadataIndexWithOffset(metadataIndexEntry.getOffset(), metadataIndexEntry, buffer, null, metadataIndexNode.getNodeType(), timeseriesMetadataMap, false);
            }
            return timeseriesMetadataMap;
        }
    }
}

