/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.source;

import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.store.file.Snapshot;
import org.apache.flink.table.store.file.utils.SnapshotManager;
import org.apache.flink.table.store.table.source.TableScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotEnumerator
implements Callable<EnumeratorResult> {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotEnumerator.class);
    private final SnapshotManager snapshotManager;
    private final TableScan scan;
    private long nextSnapshotId;

    public SnapshotEnumerator(Path tablePath, TableScan scan, long currentSnapshot) {
        this.snapshotManager = new SnapshotManager(tablePath);
        this.scan = scan;
        this.nextSnapshotId = currentSnapshot + 1L;
    }

    @Override
    @Nullable
    public EnumeratorResult call() {
        while (true) {
            if (!this.snapshotManager.snapshotExists(this.nextSnapshotId)) {
                LOG.debug("Next snapshot id {} does not exist, wait for the snapshot generation.", (Object)this.nextSnapshotId);
                return null;
            }
            Snapshot snapshot = this.snapshotManager.snapshot(this.nextSnapshotId);
            if (snapshot.commitKind() == Snapshot.CommitKind.APPEND) break;
            if (snapshot.commitKind() == Snapshot.CommitKind.OVERWRITE) {
                LOG.warn("Ignore overwrite snapshot id {}.", (Object)this.nextSnapshotId);
            }
            ++this.nextSnapshotId;
            LOG.debug("Next snapshot id {} is not APPEND, but is {}, check next one.", (Object)this.nextSnapshotId, (Object)snapshot.commitKind());
        }
        TableScan.Plan plan = this.scan.withSnapshot(this.nextSnapshotId).plan();
        EnumeratorResult result = new EnumeratorResult(this.nextSnapshotId, plan);
        LOG.debug("Find snapshot id {}.", (Object)this.nextSnapshotId);
        ++this.nextSnapshotId;
        return result;
    }

    public static class EnumeratorResult {
        public final long snapshotId;
        public final TableScan.Plan plan;

        private EnumeratorResult(long snapshotId, TableScan.Plan plan) {
            this.snapshotId = snapshotId;
            this.plan = plan;
        }
    }
}

