/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.writer;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.flink.core.fs.Path;

public interface FileWriter<T, R>
extends Closeable {
    public void write(T var1) throws IOException;

    default public void write(Iterator<T> records) throws IOException {
        while (records.hasNext()) {
            this.write(records.next());
        }
    }

    default public void write(Iterable<T> records) throws IOException {
        for (T record : records) {
            this.write(record);
        }
    }

    public long recordCount();

    public long length() throws IOException;

    public void abort();

    public R result() throws IOException;

    public static interface Factory<T, R>
    extends Serializable {
        public FileWriter<T, R> create(Path var1) throws IOException;
    }
}

