/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.eventtime;

import java.time.Duration;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.eventtime.TimestampAssigner;
import org.apache.flink.api.common.eventtime.TimestampAssignerSupplier;
import org.apache.flink.api.common.eventtime.WatermarkAlignmentParams;
import org.apache.flink.api.common.eventtime.WatermarkGenerator;
import org.apache.flink.api.common.eventtime.WatermarkGeneratorSupplier;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;

@Internal
final class WatermarksWithWatermarkAlignment<T>
implements WatermarkStrategy<T> {
    static final Duration DEFAULT_UPDATE_INTERVAL = Duration.ofMillis(1000L);
    private final WatermarkStrategy<T> strategy;
    private final String watermarkGroup;
    private final Duration maxAllowedWatermarkDrift;
    private final Duration updateInterval;

    public WatermarksWithWatermarkAlignment(WatermarkStrategy<T> strategy, String watermarkGroup, Duration maxAllowedWatermarkDrift, Duration updateInterval) {
        this.strategy = strategy;
        this.watermarkGroup = watermarkGroup;
        this.maxAllowedWatermarkDrift = maxAllowedWatermarkDrift;
        this.updateInterval = updateInterval;
    }

    @Override
    public TimestampAssigner<T> createTimestampAssigner(TimestampAssignerSupplier.Context context) {
        return this.strategy.createTimestampAssigner(context);
    }

    @Override
    public WatermarkGenerator<T> createWatermarkGenerator(WatermarkGeneratorSupplier.Context context) {
        return this.strategy.createWatermarkGenerator(context);
    }

    @Override
    public WatermarkAlignmentParams getAlignmentParameters() {
        return new WatermarkAlignmentParams(this.maxAllowedWatermarkDrift.toMillis(), this.watermarkGroup, this.updateInterval.toMillis());
    }
}

