/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.function;

import org.apache.asterix.app.function.DumpIndexReader;
import org.apache.asterix.external.api.IRecordReader;
import org.apache.asterix.metadata.declared.AbstractDatasourceFunction;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.common.api.IIndexDataflowHelper;
import org.apache.hyracks.storage.am.common.dataflow.IndexDataflowHelperFactory;

public class DumpIndexFunction
extends AbstractDatasourceFunction {
    private static final long serialVersionUID = 2L;
    private final IndexDataflowHelperFactory indexDataflowHelperFactory;
    private final RecordDescriptor recDesc;
    private final IBinaryComparatorFactory[] comparatorFactories;
    private final int[][] partitionsMap;

    public DumpIndexFunction(AlgebricksAbsolutePartitionConstraint locations, IndexDataflowHelperFactory indexDataflowHelperFactory, RecordDescriptor recDesc, IBinaryComparatorFactory[] comparatorFactories, int[][] partitionsMap) {
        super(locations);
        this.indexDataflowHelperFactory = indexDataflowHelperFactory;
        this.recDesc = recDesc;
        this.comparatorFactories = comparatorFactories;
        this.partitionsMap = partitionsMap;
    }

    public IRecordReader<char[]> createRecordReader(IHyracksTaskContext ctx, int partition) throws HyracksDataException {
        INCServiceContext serviceCtx = ctx.getJobletContext().getServiceContext();
        int[] partitions = this.partitionsMap[partition];
        IIndexDataflowHelper[] indexDataflowHelpers = new IIndexDataflowHelper[partitions.length];
        for (int i = 0; i < partitions.length; ++i) {
            indexDataflowHelpers[i] = this.indexDataflowHelperFactory.create(serviceCtx, partitions[i]);
        }
        return new DumpIndexReader(indexDataflowHelpers, this.recDesc, this.comparatorFactories);
    }
}

