/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.common.IIndexAccessParameters;

public class ConcurrentMergePolicy
implements ILSMMergePolicy {
    private int minMergeComponentCount;
    private int maxMergeComponentCount;
    private int maxComponentCount;
    private double sizeRatio;

    @Override
    public void diskComponentAdded(ILSMIndex index, boolean fullMergeIsRequested) throws HyracksDataException {
        if (fullMergeIsRequested) {
            List<ILSMDiskComponent> diskComponents = index.getDiskComponents();
            if (!diskComponents.stream().allMatch(d -> d.getState() != ILSMComponent.ComponentState.READABLE_UNWRITABLE)) {
                return;
            }
            index.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE).scheduleFullMerge();
            return;
        }
        this.scheduleMerge(index);
    }

    @Override
    public void configure(Map<String, String> properties) {
        this.minMergeComponentCount = Integer.parseInt(properties.get("min-merge-component-count"));
        this.maxMergeComponentCount = Integer.parseInt(properties.get("max-merge-component-count"));
        this.sizeRatio = Double.parseDouble(properties.get("size-ratio"));
        this.maxComponentCount = Integer.parseInt(properties.get("max-component-count"));
    }

    @Override
    public boolean isMergeLagging(ILSMIndex index) throws HyracksDataException {
        List<ILSMDiskComponent> diskComponents = index.getDiskComponents();
        if (diskComponents.size() < this.maxComponentCount) {
            return false;
        }
        if (diskComponents.stream().anyMatch(d -> d.getState() == ILSMComponent.ComponentState.READABLE_MERGING)) {
            return true;
        }
        if (!diskComponents.stream().allMatch(d -> d.getState() == ILSMComponent.ComponentState.READABLE_UNWRITABLE)) {
            throw new IllegalStateException("Illegal disk component states in isMergeLagging");
        }
        boolean isMergeTriggered = this.scheduleMerge(index);
        if (!isMergeTriggered) {
            ILSMIndexAccessor accessor = index.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
            accessor.scheduleFullMerge();
        }
        return true;
    }

    protected boolean scheduleMerge(ILSMIndex index) throws HyracksDataException {
        List<ILSMDiskComponent> diskComponents = index.getDiskComponents();
        Pair<Integer, Integer> mergeableIndexes = this.getMergableComponentsIndex(diskComponents);
        if (mergeableIndexes != null) {
            this.triggerScheduleMerge(index, diskComponents, (Integer)mergeableIndexes.getLeft(), (Integer)mergeableIndexes.getRight());
            return true;
        }
        return false;
    }

    private void triggerScheduleMerge(ILSMIndex index, List<ILSMDiskComponent> diskComponents, int startIndex, int endIndex) throws HyracksDataException {
        List<ILSMDiskComponent> mergableComponents = diskComponents.subList(startIndex, endIndex + 1);
        index.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE).scheduleMerge(mergableComponents);
    }

    protected Pair<Integer, Integer> getMergableComponentsIndex(List<ILSMDiskComponent> diskComponents) throws HyracksDataException {
        int count;
        int numComponents = diskComponents.size();
        for (count = 0; count < numComponents && diskComponents.get(count).getState() == ILSMComponent.ComponentState.READABLE_UNWRITABLE; ++count) {
        }
        if (count < this.minMergeComponentCount) {
            return null;
        }
        long[] componentSizeSum = new long[count];
        for (int i = 0; i < count; ++i) {
            componentSizeSum[i] = diskComponents.get(i).getComponentSize() + (i > 0 ? componentSizeSum[i - 1] : 0L);
        }
        for (int end = count - 1; end >= this.minMergeComponentCount - 1; --end) {
            long componentSize = componentSizeSum[end] - componentSizeSum[end - 1];
            int start = Math.max(end - this.maxMergeComponentCount + 1, 0);
            double d = componentSize;
            long l = componentSizeSum[end - 1];
            long l2 = start > 0 ? componentSizeSum[start - 1] : 0L;
            if (!(d <= this.sizeRatio * (double)(l - l2))) continue;
            return Pair.of((Object)start, (Object)end);
        }
        return null;
    }
}

